--[[
 *
 * Copyright (c) 2015-2016 - atom0s [atom0s@live.com]
 *
 * GDHook is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GDHook is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GDHook.  If not, see <http://www.gnu.org/licenses/>.
 *
]]--

---------------------------------------------------------------------------------------------------
-- desc: Main addon information. (These are required for your addon to load!)
---------------------------------------------------------------------------------------------------
_addon.author   = 'atom0s (Thanks to: GlockenGerda)';
_addon.name     = 'gconsole';
_addon.version  = '1.0';

require 'common'

---------------------------------------------------------------------------------------------------
-- func: load
-- desc: The main event called when your addon is loaded.
---------------------------------------------------------------------------------------------------
hook.register_event('load', function()
    -- Locate the console object via the given pattern..
    local sig = { 0x53, 0x8B, 0x09, 0x32, 0xDB, 0x56, 0x8B, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x8B, 0x3D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8B, 0xC8 };
    local ptr = mem:FindPattern('Grim Dawn.exe', sig, #sig, 'xxxxxxxx????xxx????x?xx');

    if (ptr == 0) then 
        HookCore:GetConsole():Write('Error! Cannot load gconsole; failed to locate required pointer!');
        return;
    end
    
    -- Read the needed pointer..
    ptr = mem:ReadULong(ptr + 0x0F);
    if (ptr == 0) then 
        HookCore:GetConsole():Write('Error! Cannot load gconsole; failed to locate required pointer!');
        return;
    end
    
    -- Read into the pointer..
    ptr = mem:ReadULong(ptr + 0x00);
    if (ptr == 0) then 
        HookCore:GetConsole():Write('Error! Cannot load gconsole; failed to locate required pointer!');
        return;
    end
    
    -- Read into the pointer..
    ptr = mem:ReadULong(ptr + 0x38);
    if (ptr == 0) then 
        HookCore:GetConsole():Write('Error! Cannot load gconsole; failed to locate required pointer!');
        return;
    end
    
    -- Set the console enabled status to true..
    mem:WriteChar(ptr + 0x08, 0x01);
    
    
    --
    -- Override the console key used.
    -- This allows GDHook to still operate as normal with the default console key.
    --
    
    sig = { 0xF6, 0xC4, 0x44, 0x7A, 0x13, 0x83, 0x79, 0x08, 0x00, 0x75, 0x0D, 0x83, 0x79, 0x04, 0xFF, 0x75 };
    ptr = mem:FindPattern('Grim Dawn.exe', sig, #sig, 'xxxxxxxxxxxxxx?x');
    if (ptr == 0) then
        HookCore:GetConsole():Write('Warning; gconsole could not override the developer console key!');
    else 
        -- Set the new console key to right-shift..
        mem:UnprotectMemory(ptr + 0x0E, 1);
        mem:WriteChar(ptr + 0x0E, 0x3B);
        HookCore:GetConsole():Write('gconsole enabled! Press \'F1\' to open the game console!');
    end
    
    --
    -- Override the console key re-press.
    -- This overrides the jump table function to be invoked when the console key is
    -- pressed while the conosle is currently open.
    --
    
    sig = { 0x8B, 0x41, 0x04, 0x48, 0x83, 0xF8, 0x7E, 0x0F, 0x87, 0x18, 0x02, 0x00, 0x00, 0x0F, 0xB6, 0x80 }
    ptr = mem:FindPattern('Grim Dawn.exe', sig, #sig, 'xxxxxxxxxxxxxxxx');
    if (ptr == 0) then
        HookCore:GetConsole():Write('Warning; gconsole could not override the developer console key repress!');
    else
        ptr = mem:ReadULong(ptr + #sig);
        mem:WriteChar(ptr + 0x3A, 0x04); -- Sets F1 to close the console.
        mem:WriteChar(ptr + 0x28, 0x0B); -- Sets ~ to do nothing.
        HookCore:GetConsole():Write('gconsole enabled! Press \'F1\' to close the game console!');
    end
    
end);